#
# Get-Version.ps1
#
# Find and return the version number from a file.
#

param (
    [Parameter(Mandatory = $true)]    
    [ValidateNotNullOrEmpty()]
    [string]
    $Path,

    [ValidateNotNullOrEmpty()]
    [string]
    $Pattern = "([0-9]+\.[0-9]+\.[0-9]+(?:[-+.\w]+)?)",

    [ValidateNotNullOrEmpty()]
    [string]
    $Boundary = "`"{version}`""
)

# Find and return the version number
if ((Get-Content -Raw $Path) -match $Boundary.Replace("{version}", $Pattern)) {
    return $Matches[1]
}
