#
# Set-Version.ps1
#
# Find and replace the version number in a list of files.
#

param (
    [Parameter(Mandatory = $true)]    
    [ValidateNotNullOrEmpty()]
    [string[]]
    $Path,

    [ValidateNotNullOrEmpty()]
    [string]
    $Pattern = "([0-9]+\.[0-9]+\.[0-9]+(?:[-+.\w]+)?)",

    [ValidateNotNullOrEmpty()]
    [string]
    $Boundary = "`"{version}`"",

    [Parameter(Mandatory = $true)]    
    [ValidateNotNullOrEmpty()]
    [string]
    $Version
)

# Find the old version number and replace it by the specified new version number
foreach ($p in $Path) {
    $old = $Boundary.Replace("{version}", $Pattern)
    $new = $Boundary.Replace("{version}", $Version)
    (Get-Content -Raw $p) -replace $old,$new | Set-Content -NoNewline $p
}
